unit Upl_dlg8;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, UplClass;


type
  TCoAuthorManager = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    Panel3: TPanel;
    BitBtn1: TBitBtn;
    Label1: TLabel;
    Label2: TLabel;
    LB_UPL: TListBox;
    LB_CO: TListBox;
    BtnErase: TSpeedButton;
    procedure BtnEraseClick(Sender: TObject);
  private
    { Private declarations }
  public
    Uploader: TDSPAuthor;
    AuthorsUPL: TDSPAuthorList;
    AuthorsCo: TDSPAuthorList;
    procedure SetUpLists;
  end;

var
  CoAuthorManager: TCoAuthorManager;

implementation


{$R *.DFM}

procedure TCoAuthorManager.SetUpLists;
var
  i: integer;
begin
  if Not Assigned( Uploader )
    then raise Exception.Create('Uploader not assigned');
  if Not Assigned( AuthorsUPL )
    then raise Exception.Create('AuthorsUPL not assigned');
  if Not Assigned( AuthorsCo )
    then raise Exception.Create('AuthorsCo not assigned');

  if AuthorsUPL.Items.Count > 1 then
  for i:= 0 to AuthorsUPL.Items.Count - 1 do
   if CompareStr(Uploader.AuthorName, AuthorsUPL.DSPAuthor[i].AuthorName ) <> 0
     then LB_UPL.Items.Add( AuthorsUPL.DSPAuthor[i].AuthorName );

  if AuthorsCO.Items.Count > 0 then
  for i:= 0 to AuthorsCO.Items.Count - 1 do
   // list anly those that are not listed in the current upload
   if AuthorsUPL.FindAuthorByName(AuthorsCO.DSPAuthor[i].AuthorName) = -1
     then LB_CO.Items.Add( AuthorsCO.DSPAuthor[i].AuthorName );
End;

procedure TCoAuthorManager.BtnEraseClick(Sender: TObject);
var
  i: integer;
begin
  if LB_CO.ItemIndex = - 1 then Exit;
  i:= AuthorsCO.FindAuthorByName(LB_CO.Items[ LB_CO.ItemIndex ]);
  if i < 0 then Exit;
  TDSPAuthor(AuthorsCO.DSPAuthor[i]).Free;
  AuthorsCO.Items.Delete(i);
  LB_CO.Items.Delete(LB_CO.ItemIndex);
end;

end.
